/*
 * Decompiled with CFR 0.152.
 */
package org.firmata;

public class Firmata {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int ANALOG = 2;
    public static final int PWM = 3;
    public static final int SERVO = 4;
    public static final int SHIFT = 5;
    public static final int I2C = 6;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    private final int MAX_DATA_BYTES = 4096;
    private final int DIGITAL_MESSAGE = 144;
    private final int ANALOG_MESSAGE = 224;
    private final int REPORT_ANALOG = 192;
    private final int REPORT_DIGITAL = 208;
    private final int SET_PIN_MODE = 244;
    private final int REPORT_VERSION = 249;
    private final int SYSTEM_RESET = 255;
    private final int START_SYSEX = 240;
    private final int END_SYSEX = 247;
    private final int SERVO_CONFIG = 112;
    private final int STRING_DATA = 113;
    private final int SHIFT_DATA = 117;
    private final int I2C_REQUEST = 118;
    private final int I2C_REPLY = 119;
    private final int I2C_CONFIG = 120;
    private final int EXTENDED_ANALOG = 111;
    private final int PIN_STATE_QUERY = 109;
    private final int PIN_STATE_RESPONSE = 110;
    private final int CAPABILITY_QUERY = 107;
    private final int CAPABILITY_RESPONSE = 108;
    private final int ANALOG_MAPPING_QUERY = 105;
    private final int ANALOG_MAPPING_RESPONSE = 106;
    private final int REPORT_FIRMWARE = 121;
    private final int SAMPLING_INTERVAL = 122;
    private final int SYSEX_NON_REALTIME = 126;
    private final int SYSEX_REALTIME = 127;
    int waitForData = 0;
    int executeMultiByteCommand = 0;
    int multiByteChannel = 0;
    int[] storedInputData = new int[4096];
    boolean parsingSysex;
    int sysexBytesRead;
    int[] digitalOutputData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] digitalInputData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    int[] analogInputData = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private final int MAX_PINS = 128;
    int[] pinModes = new int[128];
    int[] analogChannel = new int[128];
    int[] pinMode = new int[128];
    int majorVersion = 0;
    int minorVersion = 0;
    Writer out;

    public Firmata(Writer writer) {
        this.out = writer;
    }

    public void init() {
        for (int i = 0; i < 16; ++i) {
            this.out.write(0xD0 | i);
            this.out.write(1);
        }
        this.queryAnalogMapping();
    }

    public int digitalRead(int pin) {
        return this.digitalInputData[pin >> 3] >> (pin & 7) & 1;
    }

    public int analogRead(int pin) {
        return this.analogInputData[pin];
    }

    public void pinMode(int pin, int mode) {
        this.out.write(244);
        this.out.write(pin);
        this.out.write(mode);
    }

    public void digitalWrite(int pin, int value) {
        int portNumber = pin >> 3 & 0xF;
        if (value == 0) {
            int n = portNumber;
            this.digitalOutputData[n] = this.digitalOutputData[n] & ~(1 << (pin & 7));
        } else {
            int n = portNumber;
            this.digitalOutputData[n] = this.digitalOutputData[n] | 1 << (pin & 7);
        }
        this.out.write(0x90 | portNumber);
        this.out.write(this.digitalOutputData[portNumber] & 0x7F);
        this.out.write(this.digitalOutputData[portNumber] >> 7);
    }

    public void analogWrite(int pin, int value) {
        this.pinMode(pin, 3);
        this.out.write(0xE0 | pin & 0xF);
        this.out.write(value & 0x7F);
        this.out.write(value >> 7);
    }

    public void servoWrite(int pin, int value) {
        this.out.write(0xE0 | pin & 0xF);
        this.out.write(value & 0x7F);
        this.out.write(value >> 7);
    }

    private void setDigitalInputs(int portNumber, int portData) {
        this.digitalInputData[portNumber] = portData;
    }

    private void setAnalogInput(int pin, int value) {
        this.analogInputData[pin] = value;
    }

    private void setVersion(int majorVersion, int minorVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    private void queryCapabilities() {
        this.out.write(240);
        this.out.write(107);
        this.out.write(247);
    }

    private void queryAnalogMapping() {
        this.out.write(240);
        this.out.write(105);
        this.out.write(247);
    }

    private void processSysexMessage() {
        switch (this.storedInputData[0]) {
            case 106: {
                int pin;
                for (pin = 0; pin < this.analogChannel.length; ++pin) {
                    this.analogChannel[pin] = 127;
                }
                for (int i = 1; i < this.sysexBytesRead; ++i) {
                    this.analogChannel[i - 1] = this.storedInputData[i];
                }
                for (pin = 0; pin < this.analogChannel.length; ++pin) {
                    if (this.analogChannel[pin] == 127) continue;
                    this.out.write(0xC0 | this.analogChannel[pin]);
                    this.out.write(1);
                }
                break;
            }
        }
    }

    public void processInput(int inputData) {
        if (this.parsingSysex) {
            if (inputData == 247) {
                this.parsingSysex = false;
                this.processSysexMessage();
            } else {
                this.storedInputData[this.sysexBytesRead] = inputData;
                ++this.sysexBytesRead;
            }
        } else if (this.waitForData > 0 && inputData < 128) {
            --this.waitForData;
            this.storedInputData[this.waitForData] = inputData;
            if (this.executeMultiByteCommand != 0 && this.waitForData == 0) {
                switch (this.executeMultiByteCommand) {
                    case 144: {
                        this.setDigitalInputs(this.multiByteChannel, (this.storedInputData[0] << 7) + this.storedInputData[1]);
                        break;
                    }
                    case 224: {
                        this.setAnalogInput(this.multiByteChannel, (this.storedInputData[0] << 7) + this.storedInputData[1]);
                        break;
                    }
                    case 249: {
                        this.setVersion(this.storedInputData[1], this.storedInputData[0]);
                    }
                }
            }
        } else {
            int command;
            if (inputData < 240) {
                command = inputData & 0xF0;
                this.multiByteChannel = inputData & 0xF;
            } else {
                command = inputData;
            }
            switch (command) {
                case 144: 
                case 224: 
                case 249: {
                    this.waitForData = 2;
                    this.executeMultiByteCommand = command;
                    break;
                }
                case 240: {
                    this.parsingSysex = true;
                    this.sysexBytesRead = 0;
                }
            }
        }
    }

    public static interface Writer {
        public void write(int var1);
    }
}

