/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino;

import org.firmata.Firmata;
import processing.core.PApplet;
import processing.serial.Serial;

public class Arduino {
    public static final int INPUT = 0;
    public static final int OUTPUT = 1;
    public static final int ANALOG = 2;
    public static final int PWM = 3;
    public static final int SERVO = 4;
    public static final int SHIFT = 5;
    public static final int I2C = 6;
    public static final int LOW = 0;
    public static final int HIGH = 1;
    PApplet parent;
    Serial serial;
    SerialProxy serialProxy;
    Firmata firmata;

    public void dispose() {
        this.serial.dispose();
    }

    public static String[] list() {
        return Serial.list();
    }

    public Arduino(PApplet parent, String iname) {
        this(parent, iname, 57600);
    }

    public Arduino(PApplet parent, String iname, int irate) {
        this.parent = parent;
        this.firmata = new Firmata(new FirmataWriter());
        this.serialProxy = new SerialProxy();
        this.serial = new Serial((PApplet)this.serialProxy, iname, irate);
        parent.registerMethod("dispose", (Object)this);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.firmata.init();
    }

    public int digitalRead(int pin) {
        return this.firmata.digitalRead(pin);
    }

    public int analogRead(int pin) {
        return this.firmata.analogRead(pin);
    }

    public void pinMode(int pin, int mode) {
        try {
            this.firmata.pinMode(pin, mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error inside Arduino.pinMode()");
        }
    }

    public void digitalWrite(int pin, int value) {
        try {
            this.firmata.digitalWrite(pin, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error inside Arduino.digitalWrite()");
        }
    }

    public void analogWrite(int pin, int value) {
        try {
            this.firmata.analogWrite(pin, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error inside Arduino.analogWrite()");
        }
    }

    public void servoWrite(int pin, int value) {
        try {
            this.firmata.servoWrite(pin, value);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error inside Arduino.servoWrite()");
        }
    }

    public class FirmataWriter
    implements Firmata.Writer {
        public void write(int val) {
            Arduino.this.serial.write(val);
        }
    }

    public class SerialProxy
    extends PApplet {
        public void serialEvent(Serial which) {
            try {
                while (which.available() > 0) {
                    Arduino.this.firmata.processInput(which.read());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Error inside Arduino.serialEvent()");
            }
        }
    }
}

